/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.world;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.lua.LuaNotNil;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.ReadOnlyLuaTable;
import org.figuramc.figura.lua.api.entity.EntityAPI;
import org.figuramc.figura.lua.api.entity.PlayerAPI;
import org.figuramc.figura.lua.api.world.BiomeAPI;
import org.figuramc.figura.lua.api.world.BlockStateAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.LuaUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="WorldAPI", value="world")
public class WorldAPI {
    public static final WorldAPI INSTANCE = new WorldAPI();
    private static Level cached;

    public static Level getCurrentWorld() {
        ClientLevel level = Minecraft.getInstance().level;
        if (cached != level && level != null) {
            cached = level;
            return cached;
        }
        return cached;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_biome")
    public static BiomeAPI getBiome(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getBiome", x, y, z);
        return new BiomeAPI((Biome)WorldAPI.getCurrentWorld().getBiome(pos.asBlockPos()).value(), pos.asBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_block_state")
    public static BlockStateAPI getBlockState(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getBlockState", x, y, z);
        BlockPos blockPos = pos.asBlockPos();
        Level world = WorldAPI.getCurrentWorld();
        if (!world.hasChunkAt(blockPos)) {
            return new BlockStateAPI(Blocks.VOID_AIR.defaultBlockState(), blockPos);
        }
        return new BlockStateAPI(world.getBlockState(blockPos), blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.is_chunk_loaded")
    public static boolean isChunkLoaded(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getBlockState", x, y, z);
        BlockPos blockPos = pos.asBlockPos();
        Level world = WorldAPI.getCurrentWorld();
        return world.hasChunkAt(blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class, FiguraVec3.class}, argumentNames={"min", "max"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, FiguraVec3.class}, argumentNames={"minX", "minY", "minZ", "max"}), @LuaMethodOverload(argumentTypes={FiguraVec3.class, Double.class, Double.class, Double.class}, argumentNames={"min", "maxX", "maxY", "maxZ"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class, Double.class, Double.class}, argumentNames={"minX", "minY", "minZ", "maxX", "maxY", "maxZ"})}, value="world.get_blocks")
    public static List<BlockStateAPI> getBlocks(Object x, Object y, Double z, Double w, Double t, Double h) {
        Pair<FiguraVec3, FiguraVec3> pair = LuaUtils.parse2Vec3("getBlocks", x, y, z, (Object)w, t, h, 1);
        ArrayList<BlockStateAPI> list = new ArrayList<BlockStateAPI>();
        BlockPos min = ((FiguraVec3)pair.getFirst()).asBlockPos();
        BlockPos max = ((FiguraVec3)pair.getSecond()).asBlockPos();
        max = new BlockPos(Math.min(min.getX() + 8, max.getX()), Math.min(min.getY() + 8, max.getY()), Math.min(min.getZ() + 8, max.getZ()));
        if (min.compareTo((Vec3i)max) > 0) {
            throw new LuaError("Your max value can't be smaller than your min!");
        }
        Level world = WorldAPI.getCurrentWorld();
        if (!world.hasChunksAt(min, max)) {
            return list;
        }
        BlockPos.betweenClosedStream((BlockPos)min, (BlockPos)max).forEach(blockPos -> {
            BlockPos pos = new BlockPos((Vec3i)blockPos);
            list.add(new BlockStateAPI(world.getBlockState(pos), pos));
        });
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"id"})}, value="world.get_map_data")
    public static HashMap<String, Object> getMapData(String id) {
        MapItemSavedData data;
        if (id.contains("map_")) {
            id = id.replace("map_", "");
        }
        try {
            data = WorldAPI.getCurrentWorld().getMapData(new MapId(Integer.parseInt(id)));
        }
        catch (NumberFormatException e) {
            throw new LuaError("Invalid map id: " + id);
        }
        if (data == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("center_x", data.centerX);
        map.put("center_z", data.centerZ);
        map.put("locked", data.locked);
        map.put("scale", data.scale);
        ArrayList decorations = new ArrayList();
        for (MapDecoration decoration : data.getDecorations()) {
            HashMap<String, Object> decorationMap = new HashMap<String, Object>();
            decorationMap.put("type", decoration.type().toString());
            decorationMap.put("name", decoration.name() == null || decoration.name().isEmpty() ? "" : ((Component)decoration.name().get()).getString());
            decorationMap.put("x", decoration.x());
            decorationMap.put("y", decoration.y());
            decorationMap.put("rot", decoration.rot());
            decorationMap.put("image", decoration.getSpriteLocation());
            decorations.add(decorationMap);
        }
        map.put("decorations", decorations);
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_redstone_power")
    public static int getRedstonePower(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getRedstonePower", x, y, z);
        BlockPos blockPos = pos.asBlockPos();
        if (WorldAPI.getCurrentWorld().getChunkAt(blockPos) == null) {
            return 0;
        }
        return WorldAPI.getCurrentWorld().getBestNeighborSignal(blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_strong_redstone_power")
    public static int getStrongRedstonePower(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getStrongRedstonePower", x, y, z);
        BlockPos blockPos = pos.asBlockPos();
        if (WorldAPI.getCurrentWorld().getChunkAt(blockPos) == null) {
            return 0;
        }
        return WorldAPI.getCurrentWorld().getDirectSignalTo(blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"delta"})}, value="world.get_time")
    public static double getTime(double delta) {
        return (double)WorldAPI.getCurrentWorld().getGameTime() + delta;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"delta"})}, value="world.get_time_of_day")
    public static double getTimeOfDay(double delta) {
        return (double)WorldAPI.getCurrentWorld().getDayTime() + delta;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"delta"})}, value="world.get_day_time")
    public static double getDayTime(double delta) {
        return ((double)WorldAPI.getCurrentWorld().getDayTime() + delta) % 24000.0;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"delta"})}, value="world.get_day")
    public static double getDay(double delta) {
        return Math.floor(((double)WorldAPI.getCurrentWorld().getDayTime() + delta) / 24000.0);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload}, value="world.get_moon_phase")
    public static int getMoonPhase() {
        return WorldAPI.getCurrentWorld().getMoonPhase();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"delta"})}, value="world.get_rain_gradient")
    public static double getRainGradient(Float delta) {
        if (delta == null) {
            delta = Float.valueOf(1.0f);
        }
        return WorldAPI.getCurrentWorld().getRainLevel(delta.floatValue());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.is_thundering")
    public static boolean isThundering() {
        return WorldAPI.getCurrentWorld().isThundering();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_light_level")
    public static Integer getLightLevel(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getLightLevel", x, y, z);
        BlockPos blockPos = pos.asBlockPos();
        Level world = WorldAPI.getCurrentWorld();
        if (world.getChunkAt(blockPos) == null) {
            return null;
        }
        world.updateSkyBrightness();
        return world.getLightEngine().getRawBrightness(blockPos, world.getSkyDarken());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_sky_light_level")
    public static Integer getSkyLightLevel(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getSkyLightLevel", x, y, z);
        BlockPos blockPos = pos.asBlockPos();
        Level world = WorldAPI.getCurrentWorld();
        if (world.getChunkAt(blockPos) == null) {
            return null;
        }
        return world.getBrightness(LightLayer.SKY, blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_block_light_level")
    public static Integer getBlockLightLevel(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getBlockLightLevel", x, y, z);
        BlockPos blockPos = pos.asBlockPos();
        Level world = WorldAPI.getCurrentWorld();
        if (world.getChunkAt(blockPos) == null) {
            return null;
        }
        return world.getBrightness(LightLayer.BLOCK, blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class, String.class}, argumentNames={"pos", "heightmap"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, String.class}, argumentNames={"x", "z", "heightmap"})}, value="world.get_height")
    public static Integer getHeight(Object x, Double z, String heightmap) {
        Heightmap.Types heightmapType;
        BlockPos blockPos;
        FiguraVec2 pos = LuaUtils.parseVec2("getHeight", x, z);
        Level world = WorldAPI.getCurrentWorld();
        if (world.getChunkAt(blockPos = new BlockPos((int)pos.x(), 0, (int)pos.y())) == null) {
            return null;
        }
        try {
            heightmapType = heightmap != null ? Heightmap.Types.valueOf((String)heightmap.toUpperCase(Locale.US)) : Heightmap.Types.MOTION_BLOCKING;
        }
        catch (IllegalArgumentException e) {
            throw new LuaError("Invalid heightmap type provided");
        }
        return world.getHeight(heightmapType, (int)pos.x(), (int)pos.y());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.is_open_sky")
    public static Boolean isOpenSky(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("isOpenSky", x, y, z);
        BlockPos blockPos = pos.asBlockPos();
        Level world = WorldAPI.getCurrentWorld();
        if (world.getChunkAt(blockPos) == null) {
            return null;
        }
        return world.canSeeSky(blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.get_dimension")
    public static String getDimension() {
        Level world = WorldAPI.getCurrentWorld();
        return world.dimension().location().toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.get_players")
    public static Map<String, EntityAPI<?>> getPlayers() {
        HashMap playerList = new HashMap();
        for (Player player : WorldAPI.getCurrentWorld().players()) {
            playerList.put(player.getName().getString(), PlayerAPI.wrap((Entity)player));
        }
        return playerList;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class, FiguraVec3.class}, argumentNames={"pos1", "pos2"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class, Double.class, Double.class}, argumentNames={"x1", "y1", "z1", "x2", "y2", "z2"})}, value="world.get_entities")
    public static List<EntityAPI<?>> getEntities(Object x1, Object y1, Double z1, Double x2, Double y2, Double z2) {
        Pair<FiguraVec3, FiguraVec3> pair = LuaUtils.parse2Vec3("getEntities", x1, y1, z1, (Object)x2, y2, z2, 1);
        FiguraVec3 pos1 = (FiguraVec3)pair.getFirst();
        FiguraVec3 pos2 = (FiguraVec3)pair.getSecond();
        AABB aabb = new AABB(pos1.asVec3(), pos2.asVec3());
        return WorldAPI.getCurrentWorld().getEntitiesOfClass(Entity.class, aabb).stream().map(EntityAPI::wrap).collect(Collectors.toList());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"UUID"})}, value="world.get_entity")
    public static EntityAPI<?> getEntity(@LuaNotNil String uuid) {
        try {
            return EntityAPI.wrap(EntityUtils.getEntityByUUID(UUID.fromString(uuid)));
        }
        catch (Exception ignored) {
            throw new LuaError("Invalid UUID");
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.avatar_vars")
    public static Map<String, LuaTable> avatarVars() {
        HashMap<String, LuaTable> varList = new HashMap<String, LuaTable>();
        for (Avatar avatar : AvatarManager.getLoadedAvatars()) {
            LuaTable tbl = avatar.luaRuntime == null ? new LuaTable() : avatar.luaRuntime.avatar_meta.storedStuff;
            varList.put(avatar.owner.toString(), new ReadOnlyLuaTable((LuaValue)tbl));
        }
        return varList;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"block"}), @LuaMethodOverload(argumentTypes={String.class, FiguraVec3.class}, argumentNames={"block", "pos"}), @LuaMethodOverload(argumentTypes={String.class, Double.class, Double.class, Double.class}, argumentNames={"block", "x", "y", "z"})}, value="world.new_block")
    public static BlockStateAPI newBlock(@LuaNotNil String string, Object x, Double y, Double z) {
        BlockPos pos = LuaUtils.parseVec3("newBlock", x, y, z).asBlockPos();
        try {
            Level level = WorldAPI.getCurrentWorld();
            BlockState block = BlockStateArgument.block((CommandBuildContext)CommandBuildContext.simple((HolderLookup.Provider)level.registryAccess(), (FeatureFlagSet)level.enabledFeatures())).parse(new StringReader(string)).getState();
            return new BlockStateAPI(block, pos);
        }
        catch (Exception e) {
            throw new LuaError("Could not parse block state from string: " + string);
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"item"}), @LuaMethodOverload(argumentTypes={String.class, Integer.class}, argumentNames={"item", "count"}), @LuaMethodOverload(argumentTypes={String.class, Integer.class, Integer.class}, argumentNames={"item", "count", "damage"})}, value="world.new_item")
    public static ItemStackAPI newItem(@LuaNotNil String string, Integer count, Integer damage) {
        try {
            Level level = WorldAPI.getCurrentWorld();
            ItemStackAPI item = LuaUtils.parseItemStackMap("newItem", string);
            if (count != null) {
                item.itemStack.setCount(count.intValue());
            }
            if (damage != null) {
                item.itemStack.setDamageValue(damage.intValue());
            }
            return item;
        }
        catch (Exception e) {
            throw new LuaError("Could not parse item stack from string: " + string);
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.exists")
    public static boolean exists() {
        return WorldAPI.getCurrentWorld() != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.get_build_height")
    public static int[] getBuildHeight() {
        Level world = WorldAPI.getCurrentWorld();
        return new int[]{world.getMinBuildHeight(), world.getMaxBuildHeight()};
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.get_spawn_point")
    public static FiguraVec3 getSpawnPoint() {
        Level world = WorldAPI.getCurrentWorld();
        return FiguraVec3.fromBlockPos(world.getSharedSpawnPos());
    }

    public String toString() {
        return "WorldAPI";
    }
}

